% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_reduced_rank_regression.R
\name{cca_graph_rrr}
\alias{cca_graph_rrr}
\title{Graph-regularized Reduced-Rank Regression for Canonical Correlation Analysis}
\usage{
cca_graph_rrr(
  X,
  Y,
  Gamma,
  Sx = NULL,
  Sy = NULL,
  Sxy = NULL,
  lambda = 0,
  r,
  standardize = FALSE,
  LW_Sy = TRUE,
  rho = 10,
  niter = 10000,
  thresh = 1e-04,
  thresh_0 = 1e-06,
  verbose = FALSE,
  Gamma_dagger = NULL
)
}
\arguments{
\item{X}{Matrix of predictors (n x p)}

\item{Y}{Matrix of responses (n x q)}

\item{Gamma}{Graph constraint matrix (g x p)}

\item{Sx}{Optional covariance matrix for X. If NULL, computed as t(X) \%*\% X / n}

\item{Sy}{Optional covariance matrix for Y. If NULL, computed similarly; optionally shrunk via Ledoit-Wolf}

\item{Sxy}{Optional cross-covariance matrix (not currently used)}

\item{lambda}{Regularization parameter for sparsity}

\item{r}{Target rank}

\item{standardize}{Whether to center and scale X and Y (default FALSE = center only)}

\item{LW_Sy}{Whether to apply Ledoit-Wolf shrinkage to Sy}

\item{rho}{ADMM penalty parameter}

\item{niter}{Maximum number of ADMM iterations}

\item{thresh}{Convergence threshold for ADMM}

\item{thresh_0}{Threshold for small values in the coefficient matrix (default 1e-6)}

\item{verbose}{Whether to print diagnostic output}

\item{Gamma_dagger}{Optional pseudoinverse of Gamma (computed if NULL)}
}
\value{
A list with elements:
\describe{
\item{U}{Canonical direction matrix for X (p x r)}
\item{V}{Canonical direction matrix for Y (q x r)}
\item{cor}{Canonical covariances}
\item{loss}{The prediction error 1/n * \| XU - YV\|^2}
}
}
\description{
Solves a sparse canonical correlation problem using a graph-constrained reduced-rank regression formulation.
The problem is solved via an ADMM approach.
}
