% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foursail.R
\name{foursail}
\alias{foursail}
\title{Optimized R implementation of foursail (4SAIL)}
\usage{
foursail(rho, tau, bgr, param)
}
\arguments{
\item{rho}{input leaf reflectance from 400-2500nm (can be measured or modeled)}

\item{tau}{input leaf transmittance from 400-2500nm (can be measured or modeled)}

\item{bgr}{background reflectance. Usual input is
soil reflectance spectra from 400-2500nm (can be measured or modeled)}

\item{param}{A named vector of SAIL parameter values (note: program ignores case):
 \itemize{
\item [1] = Leaf angle distribution function parameter a (LIDFa)
\item [2] = Leaf angle distribution function parameter b (LIDFb)
\item [3] = Leaf angle distribution function type (see ?lidfFun)
\item [4] = Leaf area index (LAI)
\item [5] = Hot spot effect parameter (hspot)
\item [6] = Solar zenith angle (tts)
\item [7] = Observer zenith angle (tto)
\item [8] = Sun-sensor azimuth angle (psi)
}}
}
\value{
spectra matrixwith 4 reflectance factors and canopy transmission 
for wavelengths 400 to 2500nm:
 \itemize{
\item [1] = bi-hemispherical reflectance (rddt). White-sky albedo: the reflectance of the canopy
under diffuse illumination. The BRDF integrated over all viewing and illumination directions.  
\item [2] = hemispherical directional reflectance (rsdt). Black-sky albedo: reflectance of a surface
under direct light without a diffuse component. It is the integral of the BRDF over all viewing
directions.
\item [3] = directional hemispherical reflectance (rdot). Diffuse reflectance in the vieweing
direction. 
\item [4] = bi-directional reflectance (rsot). The ratio of reflected radiance in the viewing direction
to the incoming radiant flux in the solar direction. 
\item [5] = Canopy transmission of diffuse light through the canopy (taud).
\item [6] = transmission of direct light through the canopy (taus).
}
}
\description{
The foursail (or 4SAIL) radiative transfer model is commonly used to simulate bidirectional 
reflectance distribution functions within vegetation canopies. Foursail (4SAIL) refers 
to "Scattering by Arbitrary Inclined Leaves" in a 4-stream model. The four-streams represents 
the scattering and absorption of upward, downward and two directional radiative fluxes with 
four linear differential equations in a 1-D canopy. The model was initially developed by
Verhoef (1984), who extended work by Suits (1971) 4-steam model.
}
\examples{
## lower-level implementation example
## see ?fRTM for the typical mode of simulation
## e.g. fRTM(rho~prospectd+foursail) 

## 1) get parameters
params<-getDefaults(rho~prospectd+foursail) 
## getDefaults("foursail") will also work
bestpars<-params$foursail$best
## ensure the vector is named
names(bestpars) <- rownames(params$foursail)

## 2) get leaf reflectance and transmission 
rt<-fRTM(rho+tau~prospectd)

## 3) get soil reflectance to model background reflectance
data(soil)

## a linear mixture soil model 
bgRef<- bestpars["psoil"]*soil[,"drySoil"] + (1-bestpars["psoil"])*soil[,"wetSoil"]

## 4) run 4SAIL
foursail(rt[,"rho"],rt[,"tau"],bgRef,bestpars)

}
\references{
Suits, G.H., 1971. The calculation of the directional reflectance of a 
 vegetative canopy. Remote Sens. Environ. 2, 117-125.

Verhoef, W. (1984). Light scattering by leaf layers with application to 
  canopy reflectance modeling: The SAIL model. Remote Sens. Environ. 16, 125-141.
}
