% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fonction_simu_attrition.R
\name{fonction_simu_attrition}
\alias{fonction_simu_attrition}
\title{Simulate Unbalanced Panel Data}
\usage{
fonction_simu_attrition(
  N,
  TT,
  theta2_alpha_Gg,
  lambda1_alpha_St,
  sigma_alpha,
  sigma_epsilon,
  tprob
)
}
\arguments{
\item{N}{Number of units}

\item{TT}{Number of periods}

\item{theta2_alpha_Gg}{Coefficient for interaction between individual heterogeneity and time in the propensity score.}

\item{lambda1_alpha_St}{Coefficient for individual heterogeneity in the propensity score.}

\item{sigma_alpha}{Standard deviation of individual heterogeneity (alpha).}

\item{sigma_epsilon}{Standard deviation of the error term (epsilon).}

\item{tprob}{Probability target to get approximately N\emph{TT}tprob observations}
}
\value{
A data frame containing simulated data.
}
\description{
This function generates a simulated dataset with treatment assignment,
individual-level heterogeneity, and time-varying effects. It incorporates attrition
based on individual characteristics and time periods. For more details on the methodology, see:
Bellego, Benatia, and Dortet-Bernadet (2024), "The Chained Difference-in-Differences",
Journal of Econometrics, https://doi.org/10.1016/j.jeconom.2023.11.002.
}
\examples{
data_sim <- fonction_simu_attrition(N=150,TT=9,theta2_alpha_Gg = 0.01,
lambda1_alpha_St = 0.5, sigma_alpha = 2, sigma_epsilon = 0.5, tprob=0.5)
}
