% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_exponential.R
\name{cdom_fit_exponential}
\alias{cdom_fit_exponential}
\title{Fit an exponential model to CDOM data.}
\usage{
cdom_fit_exponential(wl, absorbance, wl0 = 350, startwl, endwl)
}
\arguments{
\item{wl}{The wavelength vector.}

\item{absorbance}{The absorbance vector.}

\item{wl0}{The reference wavelength (ex.: 350).}

\item{startwl}{The starting wavelength (ex.: 240).}

\item{endwl}{The ending wavelength (ex.: 600).}
}
\value{
A list containing:
\describe{
  \item{params}{A data frame with values of fitted parameters.}
  \item{r2}{R2 of the nls model.}
  \item{data}{A data frame with fitted (predicted) values of the model.}
}

The function will return \code{NULL} if the model did not converged.
}
\description{
Fit an exponential model to CDOM data.
}
\details{
\deqn{y = a0 + e^{(-S(x - \lambda_0))} + K}
}
\examples{
# Fit an exponential model using the reference wavelength 350 between 190 and 900 nm.

data(spectra)

fit <- cdom_fit_exponential(spectra$wavelength, spectra$spc1, 350, 190, 900)
str(fit)

plot(spectra$wavelength, spectra$spc1)
lines(spectra$wavelength, fit$data$.fitted, col = "red")
}

