% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slope_ratio.R
\name{cdom_slope_ratio}
\alias{cdom_slope_ratio}
\title{Calculate the slope ratio (SR) from an absorption spectra.}
\usage{
cdom_slope_ratio(wl, absorbance)
}
\arguments{
\item{wl}{The wavelength vector.}

\item{absorbance}{The absorbance vector.}
}
\value{
The value of the slope ratio.
}
\description{
Calculate the slope ratio (SR) from an absorption spectra.
}
\details{
Calculate the slope ratio (SR) as defined by Helms et al. (2008).

  \deqn{SR = \frac{S_{275-295}}{S_{350-400}}}
}
\examples{
data("spectra")

cdom_slope_ratio(spectra$wavelength, spectra$spc1)

}
\references{
\url{http://www.aslo.org/lo/toc/vol_53/issue_3/0955.html}
}

