% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{load_cebl_schedule}
\alias{load_cebl_schedule}
\title{\strong{Load CEBL Game Schedule}}
\usage{
load_cebl_schedule(seasons = NULL)
}
\arguments{
\item{seasons}{A vector of seasons (years) to filter the data.
if NULL, defaults to the range from 2019 to the current year.}
}
\value{
A data frame containing the CEBL schedule for the specified seasons.\tabular{ll}{
   Column Name \tab Type \cr
   fiba_id \tab dbl \cr
   season \tab dbl \cr
   start_time_utc \tab dttm \cr
   status \tab chr \cr
   competition \tab chr \cr
   venue_name \tab chr \cr
   period \tab dbl \cr
   home_team_id \tab dbl \cr
   home_team_name \tab chr \cr
   home_team_score \tab dbl \cr
   home_team_logo_url \tab chr \cr
   home_team_url_stats_en \tab chr \cr
   home_team_url_stats_fr \tab chr \cr
   away_team_id \tab dbl \cr
   away_team_name \tab chr \cr
   away_team_score \tab dbl \cr
   away_team_logo_url \tab chr \cr
   away_team_url_stats_en \tab chr \cr
   away_team_url_stats_fr \tab chr \cr
   stats_url_en \tab chr \cr
   stats_url_fr \tab chr \cr
   cebl_stats_url_en \tab chr \cr
   cebl_stats_url_fr \tab chr \cr
   tickets_url_en \tab chr \cr
   tickets_url_fr \tab chr \cr
   id \tab dbl \cr
   fiba_json_url \tab chr \cr
}
}
\description{
A function to load the Canadian Elite Basketball League (CEBL) schedule.
}
\examples{
load_cebl_schedule(2020:2021)
}
