% Generated by roxygen2 (4.0.2): do not edit by hand
\name{closeness.freeman}
\alias{closeness.freeman}
\title{Find the closeness centrality in a strongly connected graph}
\usage{
closeness.freeman(graph, vids = V(graph), mode = c("all", "out", "in"),
  weights = NULL, normalized = FALSE)
}
\arguments{
\item{graph}{The input graph as igraph object}

\item{vids}{Vertex sequence, the vertices for which the centrality values are returned. Default is all vertices.}

\item{mode}{Character string, defined the types of the paths used for measuring the distance in directed graphs. 'in' measures the paths to a vertex, 'out' measures paths from a vertex, all uses undirected paths. This argument is ignored for undirected graphs.}

\item{weights}{Possibly a numeric vector giving edge weights. If this is NULL, the default, and the graph has a weight edge attribute, then the attribute is used. If this is NA then no weights are used (even if the graph has a weight attribute).}

\item{normalized}{Logical scalar, whether to calculate the normalized score.}
}
\value{
A numeric vector contaning the centrality scores for the selected vertices.
}
\description{
Freeman closeness centrality defined as:
\deqn{\frac{1}{\sum_{i\neq v}d(v,i)}}{1/sum( d(v,i), i != v)}
}
\details{
Because closeness is infinite if there is no path between two vertex so freeman closeness require a strongly connected graph. In igraph if there is no (directed) path between vertex \eqn{v}{v} and \eqn{i}{i} then the total number of vertices is used in the formula instead of the path length. \cr
More detail at \href{http://www.centiserver.org/?q1=centrality&q2=Closeness_Centrality}{Closeness Centrality}
}
\examples{
g <- graph(c(1,2,2,3,3,4,4,2), directed=FALSE)
closeness.freeman(g)
}
\author{
Mahdi Jalili \email{m_jalili@farabi.tums.ac.ir}

Use igraph package closeness function.
}
\references{
Freeman, Linton C. "Centrality in social networks conceptual clarification." Social networks 1.3 (1979): 215-239.
}

