% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json.R
\name{cereal_to_json}
\alias{cereal_to_json}
\alias{cereal_from_json}
\title{Serialize and deserialize the prototype of a data frame to JSON}
\usage{
cereal_to_json(data)

cereal_from_json(x)
}
\arguments{
\item{data}{A data frame}

\item{x}{A JSON string}
}
\value{
\code{cereal_to_json()} returns a JSON string like \code{\link[jsonlite:fromJSON]{jsonlite::toJSON()}},
and \code{cereal_from_json()} returns a vctrs ptype, like \code{\link[vctrs:vec_ptype]{vctrs::vec_ptype()}}.
}
\description{
The function \code{cereal_to_json()} serializes the
\href{https://vctrs.r-lib.org/articles/type-size.html#prototype}{vctrs prototype}
of a data frame to JSON, and the function \code{cereal_from_json()} deserializes
from a JSON prototype back to a vctrs prototype.
}
\examples{

df <- tibble::tibble(
    a = 1,
    b = 2L,
    c = Sys.Date(),
    d = as.POSIXct("2019-01-01", tz = "America/New_York"),
    e = "x",
    f = factor("blue", levels = c("blue", "green", "red")),
    g = ordered("small", levels = c("small", "medium", "large"))
)

json <- cereal_to_json(df)
json

str(cereal_from_json(json))
## same as:
str(vctrs::vec_ptype(df))

}
\seealso{
\code{\link[=cereal_encode]{cereal_encode()}}, \code{\link[=cereal_decode]{cereal_decode()}}
}
