% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cheetah_utils.R
\name{column_group}
\alias{column_group}
\title{Column group definitions}
\usage{
column_group(name = NULL, columns, header_style = NULL)
}
\arguments{
\item{name}{Character string. The name to display for the column group.}

\item{columns}{Character vector. The names of the columns to include in this group.}

\item{header_style}{Named list of possibleCSS style properties to apply to the column group header.}
}
\value{
A list containing the column group definition.
}
\description{
Creates a column group definition for grouping columns in a Cheetah Grid widget.
}
\examples{
cheetah(
  iris,
  columns = list(
    Sepal.Length = column_def(name = "Length"),
    Sepal.Width = column_def(name = "Width"),
    Petal.Length = column_def(name = "Length"),
    Petal.Width = column_def(name = "Width")
  ),
  column_group = list(
    column_group(name = "Sepal", columns = c("Sepal.Length", "Sepal.Width")),
    column_group(name = "Petal", columns = c("Petal.Length", "Petal.Width"))
  )
)

}
