% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FOMT.R
\name{FOMTm}
\alias{FOMTm}
\title{First-Order Multi-Target model}
\usage{
FOMTm(t, k, m)
}
\arguments{
\item{t}{time}

\item{k}{average number of hits per time unit}

\item{m}{minimum number of hits required to degrade the
molecule}
}
\value{
Returns calculated values using the formula of FOMT model

It can be used inside the function \link[stats:nls]{nls} as the RHS of the
formula.
}
\description{
Call the function to return the formula of the Single-Hit Multi-Target
model (FOMT):
\deqn{1-(1-e^{-k\,t})^n}
}
\examples{
t <- seq(0, 100, by = 1)
k <- 0.1
n <- 200
y <- FOMTm(t, k, n)
plot(t, y, type = "l")
}
\seealso{
\code{\link[=FOMT]{FOMT()}}, \code{\link[=par_est_FOMT]{par_est_FOMT()}}, \code{\link[stats:nls]{stats::nls()}}
}
