% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxplots.R
\name{add_boxplot}
\alias{add_boxplot}
\title{Add a box plot to a chronicle report}
\usage{
add_boxplot(
  report = "",
  dt,
  value,
  groups = NULL,
  split_groups_by = NULL,
  jitter = TRUE,
  ggtheme = NULL,
  x_axis_label = NULL,
  y_axis_label = NULL,
  plot_palette = NULL,
  plot_palette_generator = NULL,
  boxplot_title = NULL,
  title_level = 2,
  echo = FALSE,
  message = FALSE,
  warning = FALSE,
  fig_width = NULL,
  fig_height = NULL
)
}
\arguments{
\item{report}{Character string containing all the R Markdown chunks previously added. Default is '', an empty report.}

\item{dt}{Table with the data for the plot.}

\item{value}{Name of the column to use as values on the y axis of the plot.}

\item{groups}{Name of the column containing the different groups.}

\item{split_groups_by}{Column to split each group.}

\item{jitter}{Whether to add the actual values of each observation over the box plots. Only done when dt has 1000 rows or less.}

\item{ggtheme}{ggplot2 theme function to apply. Default is ggplot2::theme_minimal.}

\item{x_axis_label}{Label for the x axis.}

\item{y_axis_label}{Label for the y axis.}

\item{plot_palette}{Character vector of hex codes specifying the colors to use on the plot.}

\item{plot_palette_generator}{Palette from the viridis package used in case plot_palette is unspecified or insufficient for the number of colors required.}

\item{boxplot_title}{Title of the box plot  section on the report. If NULL, chronicle will try to parse a generic title using make_title()}

\item{title_level}{Level of the section title of this plot (ie, number of # on Rmarkdown syntax.)}

\item{echo}{Whether to display the source code in the output document. Default is FALSE.}

\item{message}{Whether to preserve messages on rendering. Default is FALSE.}

\item{warning}{Whether to preserve warnings on rendering. Default is FALSE.}

\item{fig_width}{Width of the plot (in inches).}

\item{fig_height}{Height of the plot (in inches).}
}
\value{
An rmarkdown file as a character string, now containing a chunk for adding the specified box plot.
}
\description{
Add a box plot to a chronicle report
}
\examples{
html_report <- add_boxplot(report = '',
                           dt = iris,
                           value = 'Sepal.Length',
                           groups = 'Species', jitter = TRUE)
cat(html_report)
}
