% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barplots.R
\name{make_barplot}
\alias{make_barplot}
\title{Create a bar plot from a data frame through ggplotly}
\usage{
make_barplot(
  dt,
  bars,
  value = NULL,
  break_bars_by = NULL,
  up_to_n_bars = 20,
  horizontal = FALSE,
  sort_by_value = horizontal,
  sort_decreasing = TRUE,
  ggtheme = "minimal",
  x_axis_label = NULL,
  y_axis_label = NULL,
  plot_palette = NULL,
  plot_palette_generator = "plasma",
  static = FALSE
)
}
\arguments{
\item{dt}{data.frame containing the data to plot.}

\item{bars}{Name of the column containing the different groups.}

\item{value}{Name of the columns to use as value on the y axis of the plot. If NULL (default), counts will be used.}

\item{break_bars_by}{Name of the categorical variable used to break each bar}

\item{up_to_n_bars}{Plot up to this number of bars. If there are more distinct values in 'bars', the function will summarise them into an 'Others' category. Default is 20.}

\item{horizontal}{Plot the bars horizontally. Default is FALSE.}

\item{sort_by_value}{Sort the bars by value. Default is FALSE unless horizontal is TRUE.}

\item{sort_decreasing}{Sort the values decreasingly. Default is TRUE, but sort_by_value must also be TRUE.}

\item{ggtheme}{ggplot2 theme function to apply. Default is ggplot2::theme_minimal.}

\item{x_axis_label}{Label for the x axis.}

\item{y_axis_label}{Label for the y axis.}

\item{plot_palette}{Character vector of hex codes specifying the colors to use on the plot.}

\item{plot_palette_generator}{Palette from the viridis package used in case plot_palette is unspecified or insufficient for the number of colors required}

\item{static}{If TRUE (or if the dataset is over 10,000 rows), the output will be static ggplot chart instead of an interactive ggplotly chart. Default is FALSE.}
}
\value{
A plotly-ized version of a ggplot bar plot.
}
\description{
Create a bar plot from a data frame through ggplotly
}
\examples{
make_barplot(dt = iris, bars = 'Species', value = 'Sepal.Length')
make_barplot(dt = ggplot2::mpg,
             bars = 'manufacturer',
             break_bars_by = 'model',
             value = 'cty',
             horizontal = TRUE,
             sort_by_value = TRUE)
}
