% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_prep.R
\name{set_classes}
\alias{set_classes}
\title{Change column classes with a named vector}
\usage{
set_classes(
  dt,
  character = NULL,
  integer = NULL,
  double = NULL,
  logical = NULL,
  factor = NULL
)
}
\arguments{
\item{dt}{Table whose column types will be changed}

\item{character}{The columns that will be coerced to character.}

\item{integer}{The columns that will be coerced to integer.}

\item{double}{The columns that will be coerced to double.}

\item{logical}{The columns that will be coerced to logical.}

\item{factor}{The columns that will be coerced to factor.}
}
\value{
Changes by reference the types of the specified columns
}
\description{
Change column classes with a named vector
}
\examples{
library(chronicle)
iris_changed <- chronicle::set_classes(dt = iris,
                                       character = 'Species',
                                       integer = c('Sepal.Length', 'Sepal.Width'))
purrr::map_chr(iris_changed, class)
}
