% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/purely.R
\name{purely}
\alias{purely}
\title{Capture all errors, warnings and messages.}
\usage{
purely(.f, strict = 2)
}
\arguments{
\item{.f}{A function to decorate.}

\item{strict}{Controls if the decorated function should catch only errors (1), errors and
warnings (2, the default) or errors, warnings and messages (3).}
}
\value{
A function which returns a list. The first element of the list, \verb{$value},
is the result of the original function \code{.f} applied to its inputs. The second element, \verb{$log} is
\code{NULL} in case everything goes well. In case of error/warning/message, \verb{$value} is NA and \verb{$log}
holds the message. \code{purely()} is used by \code{record()} to allow the latter to handle errors.
}
\description{
Capture all errors, warnings and messages.
}
\examples{
purely(log)(10)
purely(log)(-10)
purely(log, strict = 1)(-10) # This produces a warning, so with strict = 1 nothing gets captured.
}
