% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edge_probabilities.R
\name{CalculateEdgeProbabilities}
\alias{CalculateEdgeProbabilities}
\title{Calculate pairwise edge probabilities}
\usage{
CalculateEdgeProbabilities(x, ...)
}
\arguments{
\item{x}{A cia_chain(s) or collection object where states are DAGs.}

\item{...}{Extra parameters sent to the methods. For a dag collection you can
choose to use estimated p(g|D) in two ways which can be specified using the
'method' parameter.method='sampled' for MCMC sampled frequency (which is our
recommended method) or method='score' which uses the normalised scores.}
}
\value{
Matrix of edge probabilities.
}
\description{
Calculate pairwise edge probabilities. The posterior probability of an edge
\eqn{E} given the data \eqn{D} is given by marginalising out
the graph structure \eqn{g} over the graph space \eqn{G}, such that
\deqn{p(E|D) = \sum_{g \in G} p(E|g)p(g|D).}
}
\details{
The posterior probability for a given graph p(g|D) is estimated in two
ways which can be specified using the 'method' parameter.
}
\examples{
data <- bnlearn::learning.test

dag <- UniformlySampleDAG(colnames(data))
partitioned_nodes <- DAGtoPartition(dag)

scorer <- CreateScorer(
  scorer = BNLearnScorer, 
  data = data
  )

results <- SampleChains(10, partitioned_nodes, PartitionMCMC(), scorer)
dag_chains <- PartitiontoDAG(results, scorer)
CalculateEdgeProbabilities(dag_chains)

}
