% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/running_key.R
\name{running_key}
\alias{running_key}
\title{Encrypt or decrypt a Running Key Vigenere Cipher}
\usage{
running_key(x, key, decrypt = FALSE, keep_punctuation = FALSE)
}
\arguments{
\item{x}{A vector to be encoded or decoded.}

\item{key}{A character vector of length one to use as a key}

\item{decrypt}{(Default: \code{FALSE}) The default \code{FALSE} will encrypt while
using \code{TRUE} will decrypt a given value of \code{x}.}

\item{keep_punctuation}{(Default: \code{FALSE}) The default \code{FALSE} will ignore
case and punctuation and return a lowercase result. \code{TRUE} will match the
input's case and punctuation.}
}
\value{
A character vector of length equal to x that has been transformed
}
\description{
This can be used to create (encrypt) and solve (decrypt) a
Running Key Vigenere Cipher. A Vigenere cipher uses a table of alphabetic
caesar shifts for one to twenty-six. The key is made to have an equal
length to the text by adding the first letters of the text to the key. Each
letter and corresponding key value determine the grid location to choose
the obfuscated letter from.

The Running Key Cipher Wikipedia entry provides more information on the
methods used: \url{https://en.wikipedia.org/wiki/Running_key_cipher}
}
