% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circlesplot.R
\name{circlesplot}
\alias{circlesplot}
\title{circlesplot(): Plots multiple circles with their given ratios}
\usage{
circlesplot(
  cp_vals = NULL,
  cp_text = NULL,
  cp_max = 10L,
  cp_line_width = 2L,
  cp_title = "",
  cp_color = NULL,
  cp_title_size = 1.5,
  cp_sort = "none",
  cp_tight_spacing = 1,
  cp_shape = "circle"
)
}
\arguments{
\item{cp_vals}{Vector (numeric); provides data}

\item{cp_text}{Vector (characters); provides text-labels}

\item{cp_max}{Maximum number of circles in a row (integer)}

\item{cp_line_width}{Line-width of the circles (integer)}

\item{cp_title}{Title of the plot (String)}

\item{cp_color}{Vector of hex-colors for each circle}

\item{cp_title_size}{Size of the title (numeric or integer)}

\item{cp_sort}{String; specifies if values should be sorted ('asc', 'desc'; default: 'none')}

\item{cp_tight_spacing}{Number (numeric); specifies spacing between rows (default: 1.0, possible: 1.0 - 2.0; 2.0 smallest distance)}

\item{cp_shape}{String; specifies the shape (default: 'circle'; possible: 'square')}
}
\value{
Returns object of class 'recordedPlot'. Can be used for saving the plot to a variable and replay it again (See https://benst099.github.io/circlesplot/articles/cp_vignette.html).
}
\description{
`circlesplot()` plots circles with a given diameter next to each other, so readers can observe the
ratio between them.
}
\examples{

\donttest{
library('plotrix')
colors = c('#D1BBD7', '#AE76A3', '#882E72', '#1965B0', '#5289C7', '#7BAFDE', '#4EB265', '#90C987')
values = c(5,5,4,5,5,5,2,1)
text = c('8','7','6','5','4','3','2','1')
circlesplot(cp_vals=values, cp_text=text, cp_max=3L, cp_title="Some title", cp_color=colors)
}

# Proportions among planets
library('plotrix')
colors = c('#D1BBD7', '#AE76A3', '#882E72', '#1965B0', '#5289C7', '#7BAFDE', '#4EB265', '#90C987')
planets = c('Mercury','Venus','Earth','Mars','Jupiter','Saturn','Uranus','Neptune')
diameter = c(4879.4,12103.6,12756.3,6792.4,142984,120536,51118,49528)
circlesplot(cp_vals=diameter, cp_text=planets, cp_max=3L, cp_title="Planets", cp_color=colors)

# For coloring, you can also use viridis package:
library("viridis")
values = c(5,5,4,5,5,5,2,1)
text = c('8','7','6','5','4','3','2','1')
circlesplot(cp_vals=values, cp_text=text, cp_max=4L, cp_title="Some title", cp_color=viridis(8))

}
