% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init.R
\name{cnlp_init_spacy}
\alias{cnlp_init_spacy}
\title{Interface for initializing the spacy backend}
\usage{
cnlp_init_spacy(model_name = NULL, disable = NULL, max_length = NULL)
}
\arguments{
\item{model_name}{string giving the model name for the spacy backend.
Defaults to "en_core_web_sm" (English) if set to NULL.}

\item{disable}{an optional vector of pipes to disable.}

\item{max_length}{amount of temporary memory provided to Spacy, in
characters. The default of 1000000 should work for most
applications, but can be increased when working with
long documents.}
}
\description{
This function must be run before annotating text with
the spacy backend. It sets the properties for the
spacy engine and loads the file using the R to Python
interface provided by reticulate.
}
\examples{
\dontrun{
cnlp_init_spacy(model_name = "en_core_web_sm")
}

}
\author{
Taylor B. Arnold, \email{taylor.arnold@acm.org}
}
