% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_mixmar.R
\name{fit_mixmar}
\alias{fit_mixmar}
\title{Bayesian estimation for mixture of Markov models with fixed number of components}
\description{
The function use a sampling algorithm for estimating bayesian mixture of Markov models with fixed number of components. If simulated data are used, quality of classification is assessed comparing the original partition of the sequences with the one identified by the algorithm through Danon similarity and adjusted Rand indices. 
}
\usage{
fit_mixmar(
  data,
  iter = 1000,
  burn = 500,
  num.cluster,
  states,
  A.ini = NULL,
  pi.ini = NULL,
  prior.ini = 1,
  prior.transrow = 1,
  prior.mixcoef = 1,
  ini.constr = NULL,
  trans.constr = NULL
)
}
\arguments{
\item{data}{are dataset containing a variable for categorical observations and an ID variable to identify subjects. No missing values allowed}

\item{iter}{is the number of iterations}

\item{burn}{is the number of burn-in iterations}

\item{num.cluster}{is the number of clusters}

\item{states}{is the number of states of the Markov chain}

\item{A.ini}{is the list of initial values for the transition matrices}

\item{pi.ini}{is the list of initial values for the initial probability vectors}

\item{prior.ini}{is the hyperparameter for the prior distribution of initial probability vector (Dirichlet)}

\item{prior.transrow}{is the hyperparameter for the prior distribution of transition matrices rows (Dirichlet)}

\item{prior.mixcoef}{is the hyperparameter for the prior distribution of mixture coefficients (Dirichlet)}

\item{ini.constr}{is the vector of zeros and ones indicating constrains in initial probabilities (zero: not possible to start from that state)}

\item{trans.constr}{is the matrix of zeros and ones indicating constrains in transition probabilities (zero: transition is not allowed)}
}
\value{
\item{pi.list}{Initial Markov chain probabilities for MCMC}

\item{A.list}{Transition Markov chain probabilities for MCMC}

\item{Sim.index.Danon}{Danon similarity between two partitions}

\item{Sim.index.Rand}{Rand similarity between two partitions}

\item{Conf.mat}{Confusion matrix between two partitions} 
}
\author{ Furio Urso \email{furio.urso@unipa.it} }
\examples{
\donttest{
#Compare model-based clustering with respect to another classification

# Set up initial values and hyper parameters (either fixed or random)

iter<-5   # number of iterations for the Gibbs sampler
burn<-0

num.cluster <- 3 # number of components
states <- 5 # number of states

ini.constr<-c(1, 0, 1, 1, 1)           # constrains on initial probabilities               
trans.constr<-matrix(c(1, 1, 1, 0, 1,  # constrains on transition probabilities                   
             1, 0, 1, 1, 1,                                  
             1, 1, 1, 1, 0,                                 
             0, 1, 1, 1, 1,                                 
             1, 1, 0, 1, 1),byrow=TRUE,nrow=5) 

# parameters initial values
A.ini <- 1/states*matrix(rep(1, length = (states^2)), 
                         nrow = states, byrow = TRUE, 
                         dimnames = list(as.character(c(1:states))) )
pi.ini <- rep(1/states, length = states)

# Prior distributions' hyperparameters
prior.ini<- prior.transrow <- prior.mixcoef <- 1  

# data is the simulated sequential dataset obtained in the sim_seq() example

# Run the MCMC to estimate parameters 
MMM_1 <- fit_mixmar(data, iter, burn, num.cluster = num.cluster, states = states,
                     A.ini = A.ini, pi.ini = pi.ini, prior.ini = prior.ini, 
                     prior.transrow = prior.transrow, prior.mixcoef = prior.mixcoef, 
                     ini.constr = ini.constr, trans.constr = trans.constr)

 }
}

