% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_creat_assay.R
\name{convert_creat_assay}
\alias{convert_creat_assay}
\title{Convert serum creatinine from various assays to Jaffe}
\usage{
convert_creat_assay(scr, from = "idms", to = "jaffe")
}
\arguments{
\item{scr}{vector of serum creatinine values}

\item{from}{assay type, either `jaffe`, `enzymatic` or `idms`}

\item{to}{assay type, either `jaffe`, `enzymatic` or `idms`}
}
\description{
Based on equations as reported in Srivastava et al. 2009 (Pediatr Res. 2009 Jan;65(1):113-6. doi: 10.1203/PDR.0b013e318189a6e8)
}
\examples{
convert_creat_assay(scr = c(1.1, 0.8, 0.7), from = "enzymatic", to = "jaffe")
}
