% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table-getClinDT.R
\name{getClinDTButtons}
\alias{getClinDTButtons}
\title{Get a default set of buttons to be included
in the interactive table for clinical data.}
\usage{
getClinDTButtons(
  type = c("copy", "csv", "excel", "pdf", "print"),
  typeExtra = NULL,
  opts = NULL
)
}
\arguments{
\item{type}{Character vector with type of buttons, among:
\itemize{
\item for export data: 
\itemize{
\item 'copy' (by default): copy data to clipboard
\item 'csv' (by default): export selected data to a csv file
\item 'excel' (by default): export selected data to an Excel file
\item 'pdf' (by default): export data in a PDF file, in landscape
format
\item 'print' (by default): extract the data with the print
function of the browser
}
For all these buttons, only the visible columns
(selected by the show/hide button) are exported.
The variables used for row grouping are always
exported as well.
\item to show/hide columns :
\itemize{
\item 'colvis': include a collection of buttons
to show/hide specific columns.\cr
Specific columns that should not be listed 
should be defined in \code{nonVisibleVar}
in \code{\link{getClinDT}}
}
}}

\item{typeExtra}{Character vector with type
of button(s) that should be added to the default
set of buttons.}

\item{opts}{List with extra opts for specific buttons.
The list should be named with the button type.}
}
\value{
Nested list with default buttons
to be passed on to 'buttons' option in
the \code{\link{getClinDT}}.
}
\description{
Get a default set of buttons to be included
in the interactive table for clinical data.
}
\details{
The 'colvis' button doesn't display
the non visible columns.\cr
These are defined internally with:
\preformatted{
options = list(
  columnDefs = list(
    list(targets = [X], className = 'noVis')
  )
)}
with [X] the index of the column(s) 
in Javascript notation
(starting from 0)
}
\author{
Laure Cougnaud
}
