% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_pad.R
\name{clin_group_pad}
\alias{clin_group_pad}
\title{Add Padding Between Groups in a Clinical Flextable}
\usage{
clin_group_pad(
  x,
  pad_by,
  size = 9,
  when = c("change", "notempty"),
  drop = FALSE
)
}
\arguments{
\item{x}{A clintable}

\item{pad_by}{A string indicating the column name used to detect group changes.}

\item{size}{Numeric value for the base padding size (default is 9).}

\item{when}{Character string indicating when to apply padding:
\itemize{
\item \code{"notempty"}: Add padding when the value in \code{pad_by} is not empty.
\item \code{"change"}: Add padding when the value in \code{pad_by} changes from the previous row.
}}

\item{drop}{Keep or drop the padding variable used to identify padding locations}
}
\value{
A \code{clintable} object with modified padding.
}
\description{
Adds top padding to rows in a `clintable`` based on changes
in a grouping variable or non-empty values. Useful for visually separating groups
in a table
}
\examples{

ct <- clintable(mtcars) |>
  clin_group_pad('gear')

ct <- clintable(mtcars) |>
  clin_group_pad('gear', size = 15)

}
