% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.clintable}
\alias{print.clintable}
\alias{knit_print.clintable}
\title{Clintable print method}
\usage{
\method{print}{clintable}(x, n = 3, nrows = 15, apply_defaults = TRUE, ...)

\method{knit_print}{clintable}(x, n = 3, nrows = 15, apply_defaults = TRUE, ...)
}
\arguments{
\item{x}{A clintable object}

\item{n}{Number of pages within the clintable to print. Only used when
pagination is configured}

\item{nrows}{Number of rows to print. Only used when rows aren't configured
within the pagination method}

\item{apply_defaults}{Apply default styles. These styles are stored in the
options clinify_header_default, clinify_footer_default, and
clinify_table_default respectively. Defaults to true.}

\item{...}{Additional parameters passed to flextable print method}
}
\value{
Invisible
}
\description{
Extraction of flextable print method with special handling of clintable pages
and
}
\examples{

ct <- clintable(mtcars)

print(ct)

ct <- clin_alt_pages(
  ct,
  key_cols = c("mpg", "cyl", "hp"),
  col_groups = list(
    c("disp", "drat", "wt"),
    c("qsec", "vs", "am"),
    c("gear", "carb")
  )
)

print(ct)

}
\concept{Print methods}
