% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotclmplusmodel.R
\name{plot.clmplusmodel}
\alias{plot.clmplusmodel}
\title{Plot the hazard model residuals}
\usage{
\method{plot}{clmplusmodel}(x, heat.lim = c(-2.5, 2.5), ...)
}
\arguments{
\item{x}{\code{clmplusmodel} object, model fit to plot.}

\item{heat.lim}{limits in the residuals plot.}

\item{...}{Extra arguments to be passed to the plot function.}
}
\value{
No return value, plots the hazard model residuals in triangular form.
}
\description{
This function allows to plot the hazard model residuals on the triangle payments.
}
\examples{
data(sifa.mtpl)
sifa.mtpl.rtt <- AggregateDataPP(cumulative.payments.triangle=sifa.mtpl)
clm.fit<-clmplus(sifa.mtpl.rtt, 'a')
plot(clm.fit)

}
\references{
Pittarello, Gabriele, Munir Hiabu, and Andrés M. Villegas. "Replicating and extending chain ladder 
via an age-period-cohort structure on the claim development in a run-off triangle." arXiv preprint arXiv:2301.03858 (2023).
}
