% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/realData.R
\docType{data}
\name{realCloneData}
\alias{realCloneData}
\title{Real clone data from human blood}
\format{
A \code{list} of containing one \code{list} with the full ultrametric
trees from 30 of the 32 individual donors (the two from Van Egeren are not included),
and one \code{list} containing the 42 clone trees.In three cases, there are two
timepoints from the same clone, and these are separate phylo objects.
Each \code{list} contains a tree as a class \code{phylo} object.
See ape package documentation for details on class \code{phylo} objects.
Names of each \code{phylo} object (tree) in the list matches the naming used
in the sources and also includes driver, age, and clone number.
}
\usage{
data(realCloneData)
}
\description{
42 clones (39 distinct) from 32 individual donors, 13 of whom have a diagnosis
of Myeloproliferative Neoplasm
}
\examples{
# Plot full reconstructed tree from donor PD34493
ape::plot.phylo(cloneRate::realCloneData[["fullTrees"]][["PD34493"]],
  direction = "downwards", show.tip.label = FALSE
)

}
\references{
These datasets were generated and annotated in:
\href{https://pubmed.ncbi.nlm.nih.gov/35058638/}{Williams et al. 2022}
\href{https://pubmed.ncbi.nlm.nih.gov/35650442/}{Mitchell et al. 2022}
\href{https://pubmed.ncbi.nlm.nih.gov/35650444/}{Fabre et al. 2022}
\href{https://pubmed.ncbi.nlm.nih.gov/33621486/}{Van Egeren et al. 2021}
}
\keyword{datasets}
