% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractTree.R
\name{extractTree}
\alias{extractTree}
\title{Extract a complete or pre-pruned phylogeny from the clootl datastore}
\usage{
extractTree(
  species = "all_species",
  label_type = "scientific",
  taxonomy_year = 2024,
  version = "1.5",
  data_path = FALSE
)
}
\arguments{
\item{species}{A character vector either of scientific names (directly as they come out of the
eBird taxonomy, i.e. without underscores) or of six-letter eBird species codes. Any elements of
the species vector that do not match a species-level taxon in the specified eBird taxonomy
will result in an error. eBird taxonomy files can be accessed using \code{\link[=taxonomyGet]{taxonomyGet()}}. Default is set to "all_species".}

\item{label_type}{Either "scientific" or "code". Default is set to "scientific".}

\item{taxonomy_year}{The eBird taxonomy year the tree should be output in. Current options
are 2021-2024. Both numeric and character inputs are acceptable here. Any value
aside from these years will result in an error. Default is most recent year.}

\item{version}{The desired version of the tree. Default to the most recent
version of the tree. Other versions available are '0.1','1.0','1.2','1.3','1.4' and can be
passed as a character string or as numeric.}

\item{data_path}{Default to FALSE. If a summary, dated tree is desired, this is sufficient
and does not need to be modified. However, if a user wishes to extract a set of complete
dated trees, for example to iterate an analysis across a cloud of trees, or to use an
older version of the tree than the current one packed in the data object, this function
can also accept a path to the downloaded set of trees. If you have already downloaded the AvesData repo
available at https://github.com/McTavishLab/AvesData use data_path= the path to the download location.
Alternately, you can download the full data repo using \code{\link[=get_avesdata_repo]{get_avesdata_repo()}}. This approach will download the data and
set an environmental variable AVESDATA_PATH. When AVESDATA_PATH is set, the data_path will default to this value.
To manually set AVESDATA_PATH to the location of your downloaded AvesData repo use \code{\link[=set_avesdata_repo_path]{set_avesdata_repo_path()}}}
}
\value{
One or more phylogenies of the specified taxa in the specified eBird taxonomy version and clootl
tree version.
}
\description{
This function extracts one or more phylogenies in the desired taxonomy and tree version.
It defaults to the pre-packaged summary trees, but can also be used to extract sets of
phylogenies expressing uncertainty, once they have been downloaded from the online repository.
}
\details{
This function first ensures that the requested output species overlap with species-level
taxa in the requested eBird taxonomy. If they do not, the function will error out. The onus is
on the user to ensure the requested taxa are valid. This is critical to ensure no unexpected
analysis hiccups later--you don't want to find out many steps later that your dataset doesn't
match your phylogeny. The eBird database is currently (as of Mar 2025) in 2024 taxonomy.
The 2025 taxonomy will be released
to the public in October or November 2025. The intention is to release a tree in 2025 taxonomy
concurrently with the publication of the taxonomy itself. Going forward, we will begin
sunsetting older taxonomies, and intend to maintain the current year plus the two
previous years.
}
\examples{
ex1 <- extractTree(species=c("amerob", "canwar", "reevir1", "yerwar", "gockin"),
   label_type="code")
ex2 <- extractTree(species=c("Turdus migratorius",
                             "Setophaga dominica",
                             "Setophaga ruticilla",
                             "Sitta canadensis"),
   label_type="scientific",
   taxonomy_year="2021",
   version="1.5")

}
\author{
Eliot Miller, Luna Sanchez Reyes, Emily Jane McTavish
}
