% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustMD_UtilityFunctions.R
\name{clustMDparcoord}
\alias{clustMDparcoord}
\title{Parallel coordinates plot adapted for \code{clustMD} output}
\usage{
clustMDparcoord(x, col = 1, xlabels = NULL, lty = 1, var.label = FALSE,
  xlab = "", ylab = "", ...)
}
\arguments{
\item{x}{a matrix or data frame who columns represent variables. Missing 
values are allowed.}

\item{col}{a vector of colours, recycled as necessary for each observation.}

\item{xlabels}{a character vector of variable names for the x axis.}

\item{lty}{a vector of line types, recycled as necessary for each
observation.}

\item{var.label}{if TRUE, each variable's axis is labelled with maximum and
minimum values.}

\item{xlab}{label for the X axis.}

\item{ylab}{label for the Y axis.}

\item{...}{further graphics parameters which are passed to \code{matplot}.}
}
\value{
A parallel coordinates plot is drawn with one line for each cluster.
}
\description{
Produces a parallel coordinates plot as \code{parcoord} in the \code{MASS}
library with some minor adjustments.
}
\references{
Wegman, E. J. (1990) Hyperdimensional data analysis using 
    parallel coordinates. Journal of the American Statistical Association 
    85, 664-675.

    Venables, W. N. and Ripley, B. D. (2002) Modern Applied Statistics with
    S. Fourth edition. Springer.
}
\keyword{device}
\keyword{internal}
