% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterhap.R
\name{clusterhap}
\alias{clusterhap}
\title{clusterhap function identifies haplotypes within QTL.}
\usage{
clusterhap(x, Print = FALSE)
}
\arguments{
\item{x}{a data.frame that should be loaded with read.table function.
Each row represents the individuals while each column represents the markers.
The first column contains the names of the genotypes.}

\item{Print}{option for print the clusterhap result.
The default is FALSE}
}
\value{
a matrix with the haplotypes
}
\description{
This function groups together all individuals of a population
with the same haplotype.
}
\details{
Each group contains individual with the same allele in each SNP,
whether or not missing data.
}
\examples{

#### Simple simulated data
data("sim_qtl")
clusterhap(sim_qtl, Print=TRUE)

### Real experimental data

\dontrun{
data(rice_qtl)
clusterhap(rice_qtl)
}
}
\author{
Gaston Quero, Sebastian Simondi, Victoria Bonnecarrere, Lucia Gutierrez.
}
\seealso{
read.table function
}

