% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_strings.R
\name{cluster_strings}
\alias{cluster_strings}
\title{Cluster Strings by Edit-Distance}
\usage{
cluster_strings(s_vec, clean = T, method = "osa", max_dist = 3,
  algo = "cc")
}
\arguments{
\item{s_vec}{a vector of character strings}

\item{clean}{whether to space-squish and de-duplicate s_vec}

\item{method}{one of "osa","lv","dl" (as in `stringdist`)}

\item{max_dist}{max distance (typically damerau-levenshtein) between related strings.}

\item{algo}{one of "cc" (connected components) or "eb" (edge betweeness)}
}
\value{
a data frame containing cluster membership for each input string
}
\description{
Cluster Strings by Edit-Distance
}
\examples{
s_vec <- c("alcool","alcohol","alcoholic","brandy","brandie","cachaça")
s_clust <- cluster_strings(s_vec,method="lv",max_dist=3,algo="cc")
s_clust$df_clusters
}
