% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch-search.R
\name{batch_search}
\alias{batch_search}
\title{Encapsulation of CEU Mass Mediator batch search API}
\usage{
batch_search(
  cmm_url = "https://ceumass.eps.uspceu.es/api/v3/batch",
  metabolites_type = "all-except-peptides",
  databases = "[\\"all-except-mine\\"]",
  masses_mode = "mz",
  ion_mode = "positive",
  adducts = "[\\"M+H\\",\\"M+Na\\"]",
  tolerance = 10,
  tolerance_mode = "ppm",
  unique_mz
)
}
\arguments{
\item{cmm_url}{A URL string for the CEU Mass Mediator or a local API endpoint.}

\item{metabolites_type}{Search metabolites type: "all-except-peptides", "only-lipids", or "all-including-peptides".}

\item{databases}{A JSON array of databases to search: e.g., "all", "HMDB", "LipidMaps", etc.}

\item{masses_mode}{Masses mode: "neutral" or "mz".}

\item{ion_mode}{Ionization mode: "positive" or "negative".}

\item{adducts}{A JSON array of adducts to include in the search, e.g., '["M+H", "M+Na"]'.}

\item{tolerance}{A numeric tolerance value (range: 0-100).}

\item{tolerance_mode}{Tolerance mode: "ppm" or "mDa".}

\item{unique_mz}{A numeric vector of unique m/z values for the search.}
}
\value{
A dataframe containing search results.
}
\description{
\code{batch_search} returns a dataframe with the results from the database search.
}
\examples{
\dontrun{
df_pos <- batch_search(
  "https://ceumass.eps.uspceu.es/api/v3/batch",
  "all-except-peptides",
  '["all-except-mine"]',
  "mz",
  "positive",
  '["M+H","M+Na"]',
  10,
  "ppm",
  c(670.4623, 1125.2555, 602.6180)
)
}
}
