% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCode.r
\name{GetData}
\alias{GetData}
\title{Retrieve Initialized Data from the Cmpp Model}
\value{
A list containing:
\item{features}{A numeric matrix of predictor variables. Each row corresponds to an observation.}
\item{timee}{A numeric vector of failure times corresponding to observations.}
\item{delta1}{A binary vector indicating the occurrence of the first competing event (1 for observed).}
\item{delta2}{A binary vector indicating the occurrence of the second competing event (1 for observed).}
}
\description{
This function retrieves the data initialized in the Cmpp model, including the feature matrix, failure times,
and competing risks indicators (\code{delta1} and \code{delta2}).
}
\details{
This function requires the Cmpp model to be initialized using the \code{Initialize} function. It retrieves the
data stored in the Cmpp object, which includes the feature matrix, failure times, and the binary indicators for
competing risks. If the Cmpp object is not initialized, the function will throw an error.
}
\examples{
library(cmpp)
data("fertility_data")
Nam <- names(fertility_data)
fertility_data$Education
datt <- make_Dummy(fertility_data, features = c("Education"))
datt <- datt$New_Data 
datt['Primary_Secondary'] <- datt$`Education:2`
datt['Higher_Education'] <- datt$`Education:3`
datt$`Education:2` <- datt$`Education:3` <- NULL
datt2 <- make_Dummy(datt, features = 'Event')$New_Data
d1 <- datt2$`Event:2`
d2 <- datt2$`Event:3`
feat <- datt2[c('age', 'Primary_Secondary', 'Higher_Education')] |> 
   data.matrix()
timee <- datt2[['time']]
Initialize(feat, timee, d1, d2, 1e-10)
data <- GetData()
print(data$features)  # Feature matrix
print(data$timee)      # Failure times
print(data$delta1)    # Indicator for the first competing event
print(data$delta2)    # Indicator for the second competing event
}
