% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCode.r
\name{Initialize}
\alias{Initialize}
\title{Initialize Data for the Cmpp Model}
\usage{
Initialize(features, x, delta1, delta2, h)
}
\arguments{
\item{features}{A numeric matrix of predictor variables. Each row corresponds to an observation.}

\item{x}{A numeric vector of failure times corresponding to observations.}

\item{delta1}{A binary vector indicating the occurrence of the first competing event (1 for observed).}

\item{delta2}{A binary vector indicating the occurrence of the second event (1 for observed).}

\item{h}{A numeric value specifying the step size for numerical gradient computations.}
}
\value{
This function returns \code{NULL}. The initialized data is stored in the package environment.
}
\description{
This function initializes the data used in the Cmpp model by storing the feature matrix, failure times,
and the competing risks indicators in the model environment. These are required for subsequent computations.
}
\details{
This function does not return any value but sets up internal data structures required for model computation.
Ensure that \code{features}, \code{x}, \code{delta1}, and \code{delta2} have matching lengths or dimensions.
}
\examples{
library(cmpp)
features <- matrix(rnorm(100), ncol = 5)
x <- rnorm(20)
delta1 <- sample(0:1, 20, replace = TRUE)
delta2 <- 1 - delta1
Initialize(features, x, delta1, delta2, h = 1e-5)
}
