% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCode.r
\name{compute_hessian}
\alias{compute_hessian}
\title{Compute the Hessian Matrix of the Log-Likelihood}
\usage{
compute_hessian(param)
}
\arguments{
\item{param}{A numeric vector of parameters for which the Hessian matrix is calculated.}
}
\value{
A numeric matrix representing the Hessian matrix at the specified parameters.
}
\description{
Calculates the Hessian matrix of the negative log-likelihood function using finite differences.
This function is useful for understanding the curvature of the log-likelihood surface and for optimization purposes.
}
\details{
This function approximates the Hessian matrix using central finite differences.
Ensure that the step size \code{h} is appropriately set during initialization to avoid numerical instability.
The function requires the data to be initialized using \code{Initialize} before being called.
}
\examples{
library(cmpp)
data("fertility_data")
Nam <- names(fertility_data)
fertility_data$Education
datt <- make_Dummy(fertility_data, features = c("Education"))
datt <- datt$New_Data 
datt['Primary_Secondary'] <- datt$`Education:2`
datt['Higher_Education'] <- datt$`Education:3`
datt$`Education:2` <- datt$`Education:3` <- NULL
datt2 <- make_Dummy(datt, features = 'Event')$New_Data
d1 <- datt2$`Event:2`
d2 <- datt2$`Event:3`
feat <- datt2[c('age', 'Primary_Secondary', 'Higher_Education')] |> 
   data.matrix()
timee <- datt2[['time']]
Initialize(feat, timee, d1, d2, 1e-10)
# Estimate model parameters using default initial values and the BFGS method
result <- estimate_parameters()
print(result)
param <- c(0.5, 0.1, 0.6, 0.2)
hessian <- compute_hessian(param)
print(hessian)
}
