% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{generateEffectPlot}
\alias{generateEffectPlot}
\title{Function to define a plot, either showing the main or interaction effect in bold.}
\usage{
generateEffectPlot(
  data,
  x,
  y,
  fillColourGroup,
  ytext = "testylab",
  xtext = "testxlab",
  legendPos = c(0.1, 0.23),
  legendHeading = NULL,
  shownEffect = "main",
  effectLegend = FALSE,
  effectDescription = NULL,
  xLabelsOverwrite = NULL,
  useLatexMarkup = FALSE,
  numberColors = 6
)
}
\arguments{
\item{data}{the data frame}

\item{x}{factor shown on the x-axis}

\item{y}{dependent variable}

\item{fillColourGroup}{group to color}

\item{ytext}{label for y-axis}

\item{xtext}{label for x-axis}

\item{legendPos}{position for legend}

\item{legendHeading}{custom heading for legend}

\item{shownEffect}{either "main" or "interaction"}

\item{effectLegend}{TRUE: show legend for effect (Default: FALSE)}

\item{effectDescription}{custom label for effect}

\item{xLabelsOverwrite}{custom labels for x-axis}

\item{useLatexMarkup}{use latex font and markup}

\item{numberColors}{number of colors}
}
\value{
a plot
}
\description{
Function to define a plot, either showing the main or interaction effect in bold.
}
\examples{
\donttest{
set.seed(123)
main_df <- data.frame(
  strategy    = factor(rep(c("A", "B"), each = 20)),
  Emotion     = factor(rep(c("Happy", "Sad"), times = 20)),
  trust_mean  = rnorm(40, mean = 5, sd = 1)
)

generateEffectPlot(
  data = main_df,
  x = "strategy",
  y = "trust_mean",
  fillColourGroup = "Emotion",
  ytext = "Trust",
  xtext = "Strategy",
  legendPos = c(0.1, 0.23)
)
}
}
