% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_arg_responses.R
\name{validate_arg_responses}
\alias{validate_arg_responses}
\title{Check and validate arguments \code{response} and \code{responses}}
\usage{
validate_arg_responses(
  df = NULL,
  responses = NULL,
  max_responses = NULL,
  quiet = FALSE,
  function_name = NULL
)
}
\arguments{
\item{df}{(required; dataframe, tibble, or sf) A dataframe with responses
(optional) and predictors. Must have at least 10 rows for pairwise
correlation analysis, and \code{10 * (length(predictors) - 1)} for VIF.
Default: NULL.}

\item{responses}{(optional; character, character vector, or NULL) Name of
one or several response variables in \code{df}. Default: NULL.}

\item{max_responses}{(required, integer or NULL) Maximum number of responses to consider. Default: NULL}

\item{quiet}{(optional; logical) If FALSE, messages are printed. Default: FALSE.}

\item{function_name}{(optional, character string) Name of the function performing the argument check. Default: NULL}
}
\value{
character string: response name
}
\description{
Internal function validate the arguments \code{response} and \code{responses}. It checks that its value exists as a column name of \code{df},
}
\examples{

data(vi_smol)

x <- validate_arg_responses(
  df = vi_smol,
  responses = "vi_numeric"
)

attributes(x)$validated

}
\seealso{
Other argument_validation: 
\code{\link{drop_geometry_column}()},
\code{\link{validate_arg_df}()},
\code{\link{validate_arg_df_not_null}()},
\code{\link{validate_arg_encoding_method}()},
\code{\link{validate_arg_f}()},
\code{\link{validate_arg_function_name}()},
\code{\link{validate_arg_max_cor}()},
\code{\link{validate_arg_max_vif}()},
\code{\link{validate_arg_predictors}()},
\code{\link{validate_arg_preference_order}()},
\code{\link{validate_arg_quiet}()}
}
\concept{argument_validation}
