% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlbcolors.r
\name{mlb.colors}
\alias{mlb.colors}
\title{MLB colors}
\usage{
mlb.colors(set = c("diamondbacks", "braves", "orioles", "red_sox", "cubs",
  "white_sox", "reds", "indians", "rockies", "tigers", "astros", "royals",
  "angels", "dodgers", "marlins", "brewers", "twins", "mets", "yankees",
  "athletics", "phillies", "pirates", "padres", "giants", "mariners",
  "cardinals", "rays", "rangers", "blue_jays", "nationals"))
}
\arguments{
\item{set}{Character string denoting an MLB team's color palette.}
}
\value{
Vector of character strings from the selected MLB team's color palette.
}
\description{
Function returns a vector of character strings from a selected MLB team's color palette. The team options are c("diamondbacks", "braves", "orioles", "red_sox", "cubs", "white_sox", "reds", "indians", "rockies", "tigers", "astros", "royals", "angels", "dodgers", "marlins", "brewers", "twins", "mets", "yankees", "athletics", "phillies", "pirates", "padres", "giants", "mariners", "cardinals", "rays", "rangers", "blue_jays", "nationals").
}
\examples{
\dontrun{
# Colorado Rockies colors
(pal = mlb.colors("rockies"))
pie(rep(1, length(pal)), labels = sprintf("\%d (\%s)", seq_along(pal), pal), col = pal)

# Seattle Mariners colors
(pal = mlb.colors("mariners"))
pie(rep(1, length(pal)), labels = sprintf("\%d (\%s)", seq_along(pal), pal), col = pal)
}
}
\author{
Charles Crabtree \email{ccrabtr@umich.edu}
}
