% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranked_combs.R
\name{ranked_combs}
\alias{ranked_combs}
\title{Rank combinations.}
\usage{
ranked_combs(combo_table, min_SE = 0, min_SP = 0)
}
\arguments{
\item{combo_table}{a data.frame with SE, SP and number of composing markers for each combination (returned by se_sp()).}

\item{min_SE}{a numeric that specifies the min value of SE that a combination must have to be filtered-in.}

\item{min_SP}{a numeric that specifies the min value of SP that a combination must have to be filtered-in.}
}
\value{
a named list containing:
\itemize{
\item $table, a data.frame with ranked combination, reporting: SE, SP, number of markers composing the combination and the score.
\item $bubble_chart, a dot plot showing the selected 'gold' combinations
}
}
\description{
A function to rank combinations by a Youden index and select them if they have a min SE and/or SP.
}
\details{
This function is meant to help the user in finding the best combinations (in the first rows) and allows also (not mandatory) the SE/SP-dependent filtering of combinations.
}
\examples{
\dontrun{
demo_data # combiroc built-in demo data (proteomics data from Zingaretti et al. 2012 - PMC3518104)

combs <- combi(data= demo_data, signalthr=450, combithr=1, case_class='A')  # compute combinations
                                                                  # compute SE and SP
                                                               # of each combination



# To rank combinations by Youden index and filter-out the ones with SE < min_SE and SP < min_SP

rc <- ranked_combs(combo_table= combs, min_SE=40, min_SP=80)
rc$table # to visualize the selected gold combinations through a data.frame
rc$bubble_chart # to visualize the selected gold combinations through a data.frame
}
}
