% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiphenassoc.R
\name{multiphenassoc}
\alias{multiphenassoc}
\title{Multiple PGS Associations from different Phenotypes}
\usage{
multiphenassoc(
  df = NULL,
  prs_col = "SCORESUM",
  phenotype_col = "Phenotype",
  scale = TRUE,
  covar_col = NA,
  verbose = TRUE,
  log = ""
)
}
\arguments{
\item{df}{a dataframe with individuals on each row, and at least the following
columns:
\itemize{
\item one ID column,
\item one PGS column, with numerical continuous values following a normal distribution,
\item one Phenotype column, can be numeric (Continuous Phenotype), character, boolean or factors (Discrete Phenotype)
}}

\item{prs_col}{a character specifying the PGS column name}

\item{phenotype_col}{a character vector specifying the Phenotype column names}

\item{scale}{a boolean specifying if scaling of PGS should be done before testing}

\item{covar_col}{a character vector specifying the covariate column names (facultative)}

\item{verbose}{a boolean (TRUE by default) to write in the console/log messages.}

\item{log}{a connection, or a character string naming the file to print to.
If "" (by default), it prints to the standard output connection, the console unless redirected by sink.}
}
\value{
return a data frame showing the association of the PGS on the Phenotypes
with the following columns:
\itemize{
\item PGS: the name of the PGS
\item Phenotype: the name of Phenotype
\item Phenotype_type: either \code{'Continuous'}, \code{'Ordered Categorical'}, \code{'Categorical'} or \code{'Cases/Controls'}
\item Stat_method: association function detects what is the phenotype type and what is the best way to analyse it, either \code{'Linear regression'}, \code{'Binary logistic regression'}, \code{'Ordinal logistic regression'} or \code{'Multinomial logistic regression'}
\item Covar: list all the covariates used for this association
\item N_cases: if Phenotype_type is Cases/Controls, gives the number of cases
\item N_controls: if Phenotype_type is Cases/Controls, gives the number of controls
\item N: the number of individuals/samples
\item Effect: if Phenotype_type is Continuous, it represents the Beta coefficient of linear regression; Otherwise, it is the OR of logistic regression
\item SE: standard error of the Beta coefficient (if Phenotype_type is Continuous)
\item lower_CI: lower confidence interval of the related Effect (Beta or OR)
\item upper_CI: upper confidence interval of the related Effect (Beta or OR)
\item P_value: associated P-value
}
}
\description{
\code{multiphenassoc()} takes a distribution of PGS and multiple Phenotypes and eventual confounders.
Returns a data frame showing the association results
}
