% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/medians.R
\name{summary.complex}
\alias{summary.complex}
\title{summary method for complex objects}
\usage{
\method{summary}{complex}(object, ..., digits)
}
\arguments{
\item{object}{a complex vector or scalar.}

\item{...}{additional arguments, not used.}

\item{digits}{integer specifying the number of digits to include in the summary values.}
}
\value{
A list containing the length of the object, and a complex named vector containing in the median, mean, variance, and pseudo variance of the object; in that order.
}
\description{
The base summary method for complex objects only reports their length and that they are complex..
This improved method returns the length, as well as the mean, median, variance, and pseudo variance of the given complex object.
}
\examples{
set.seed(4242)
n <- 8
foo <- complex(real = rnorm(n), imaginary = rnorm(n))
summary(foo)
}
