\name{make_blk}
\alias{make_blk}
\title{Make \code{blockmodel} objects using CONCOR partition}
\description{
Use the CONCOR algorithm to find network positions, continuing through a specified number
of splits, and output \code{blockmodel} object(s).
}
\usage{
make_blk(adj_list, nsplit = 1)
}
\arguments{
  \item{adj_list}{A list of adjacency matrices, each representing a different relation
  for the same nodes.}

  \item{nsplit}{The total number of splits CONCOR will (attempt to) perform.}
}
\details{
Runs \code{\link{concor}} to a specified number of splits (\code{nsplit}) and creates a
\code{blockmodel} type object from each input matrix in \code{adj_list} using the
membership vector generated by \code{\link{concor}}. This object holds summary
information of interest, such as the reduced density matrix, as well as the permuted
adjacency matrix that shows the blocked structure.

See the help file for \code{\link[sna]{blockmodel}} in the \pkg{sna} package for more
details.
}
\value{
A list of \code{blockmodel} type objects, one for each input adjacency matrix. Each
blockmodel in the list corresponds to one relation.
}

\seealso{
  \code{\link[sna]{blockmodel}},
  \code{\link{concor}}
}
\examples{
g1 <- matrix(c(0, 0, 0, 1, 1, 0, 1, 0, 1, 1, 0, 1, 1, 0, 1, 0), ncol = 4)
rownames(g1) <- c("a", "b", "c", "d")
colnames(g1) <- c("a", "b", "c", "d")

g2 <- matrix(c(0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 1, 0, 0), ncol = 4)
rownames(g2) <- c("a", "b", "c", "d")
colnames(g2) <- c("a", "b", "c", "d")

gl <- list(g1, g2)
make_blk(gl)
}

