% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concord_sitc.R
\name{concord_sitc}
\alias{concord_sitc}
\title{Concord Within SITC Codes}
\source{
Concordance tables provided by:
\itemize{
  \item United Nations Trade Statistics <https://unstats.un.org/unsd/trade/classifications/correspondence-tables.asp>
}
}
\usage{
concord_sitc(sourcevar, origin, destination, dest.digit = 4, all = FALSE)
}
\arguments{
\item{sourcevar}{An input character vector of SITC codes. The function accepts 1 to 5-digit SITC codes.}

\item{origin}{A string setting the input industry classification: "SITC1" (1950), "SITC2" (1974), "SITC3" (1985), "SITC4" (2006).}

\item{destination}{A string setting the output industry classification: "SITC1" (1950), "SITC2" (1974), "SITC3" (1985), "SITC4" (2006).}

\item{dest.digit}{An integer indicating the preferred number of digits for output codes. Allows 1 to 5-digit SITC codes. The default is 4 digits.}

\item{all}{Either TRUE or FALSE. If TRUE, the function will return (1) all matched outputs for each input, and (2) the share of occurrences for each matched output among all matched outputs. Users can use the shares as weights for more precise concordances. If FALSE, the function will only return the matched output with the largest share of occurrences (the mode match). If the mode consists of multiple matches, the function will return the first matched output.}
}
\value{
The matched output(s) for each element of the input vector. Either a list object when all = TRUE or a character vector when all = FALSE.
}
\description{
Concords codes within the Standard International Trade Classification classification (SITC Revision 1, 2, 3, 4).
}
\note{
Always include leading zeros in codes (e.g. use SITC code 01211 instead of 1211)---results may be buggy otherwise.
}
\examples{
# SITC4 to SITC3
concord_sitc(sourcevar = c("22240", "04110"), origin = "SITC4",
             destination = "SITC3", dest.digit = 5, all = TRUE)

# SITC1 to SITC4
concord_sitc(sourcevar = c("22180", "04100"), origin = "SITC1",
             destination = "SITC4", dest.digit = 5, all = TRUE)
}
