% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcmvtruncnorm.R
\name{dcmvtruncnorm}
\alias{dcmvtruncnorm}
\title{Density of the Conditional Truncated Multivariate Normal}
\usage{
dcmvtruncnorm(
  y,
  mean,
  sigma,
  lower,
  upper,
  dependent.ind,
  given.ind,
  X.given,
  log = FALSE
)
}
\arguments{
\item{y}{vector or matrix of quantiles of Y. If a matrix, each row is taken to be a quantile. This is the quantity that the density is calculated from.}

\item{mean}{the mean vector for Z of length of n}

\item{sigma}{the symmetric and positive-definite covariance matrix of dimension n x n of Z.}

\item{lower}{a vector of lower bounds of length n that truncate Z}

\item{upper}{a vector of upper bounds of length n that truncate Z}

\item{dependent.ind}{a vector of integers denoting the indices of dependent variable Y.}

\item{given.ind}{a vector of integers denoting the indices of conditioning variable X.  If specified as integer vector of length zero or left unspecified, the unconditional density is returned.}

\item{X.given}{a vector of reals denoting the conditioning value of X. This should be of the same length as \code{given.ind}}

\item{log}{logical; if \code{TRUE}, densities d are given as log(d).}
}
\description{
Calculates the density of truncated conditional multivariate normal Y|X: \eqn{f(Y = y | X = X.given)}. See the vignette for more information.
}
\examples{
# Example 1: X2,X3,X5|X2,X4 ~ N_3(1, Sigma)
# truncated between -10 and 10.
d <- 5
rho <- 0.9
Sigma <- matrix(0, nrow = d, ncol = d)
Sigma <- rho^abs(row(Sigma) - col(Sigma))

# Log-density of 0
dcmvtruncnorm(
  rep(0, 3),
  mean = rep(1, 5),
  sigma = Sigma,
  lower = rep(-10, 5),
  upper = rep(10, d),
  dependent.ind = c(2, 3, 5),
  given.ind = c(1, 4), X.given = c(1, -1),
  log = TRUE
)
}
\references{
Horrace, W.C. 2005. Some results on the multivariate truncated normal distribution. Journal of Multivariate Analysis, 94, 209–221. \url{https://surface.syr.edu/cgi/viewcontent.cgi?article=1149&context=ecn}
}
