% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errors.R
\docType{data}
\name{ME}
\alias{ME}
\alias{MAE}
\alias{MSE}
\alias{RMSE}
\alias{MPE}
\alias{MAPE}
\alias{MASE}
\alias{RMSSE}
\alias{point_measures}
\title{Point estimate accuracy measures}
\format{
An object of class \code{list} of length 8.
}
\usage{
ME(resid, na.rm = TRUE)

MAE(resid, na.rm = TRUE, ...)

MSE(resid, na.rm = TRUE, ...)

RMSE(resid, na.rm = TRUE, ...)

MPE(resid, actual, na.rm = TRUE, ...)

MAPE(resid, actual, na.rm = TRUE, ...)

MASE(
  resid,
  train,
  demean = FALSE,
  na.rm = TRUE,
  period,
  d = period == 1,
  D = period > 1,
  ...
)

RMSSE(
  resid,
  train,
  demean = FALSE,
  na.rm = TRUE,
  period,
  d = period == 1,
  D = period > 1,
  ...
)

point_measures
}
\arguments{
\item{resid}{A numeric vector of residuals from either the validation or test data.}

\item{na.rm}{If \code{TRUE}, remove missing values before calculating the measure.}

\item{...}{Additional arguments for each measure.}

\item{actual}{A numeric vector of responses matching the forecasts (for percentage measures).}

\item{train}{A numeric vector of responses used to train the model (for scaled measures).}

\item{demean}{Should the response be demeaned (for MASE and RMSSE)?}

\item{period}{The seasonal period of the data.}

\item{d}{Should the response model include a first difference?}

\item{D}{Should the response model include a seasonal difference?}
}
\value{
For the individual functions (\code{ME}, \code{MAE}, \code{MSE}, \code{RMSE}, \code{MPE}, \code{MAPE}, \code{MASE}, \code{RMSSE}),
returns a single numeric scalar giving the requested accuracy measure.

For the exported object \code{point_measures}, returns a \strong{named list of functions}
that can be supplied to higher-level accuracy routines.
}
\description{
Accuracy measures for point forecast residuals.
}
\examples{
# Toy residuals and data
set.seed(1)
y_train <- rnorm(50)
y_test  <- rnorm(10)
fcast   <- y_test + rnorm(10, sd = 0.2)
resid   <- y_test - fcast

# Basic measures
ME(resid)
MAE(resid)
RMSE(resid)

# Percentage measures require 'actual'
MPE(resid, actual = y_test)
MAPE(resid, actual = y_test)

# Scaled measures require training data (and seasonal period if applicable)
MASE(resid, train = y_train, period = 1)
RMSSE(resid, train = y_train, period = 1)

}
\keyword{datasets}
