% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ms_create_ssml.R
\name{ms_create_ssml}
\alias{ms_create_ssml}
\title{Create Speech Synthesis Markup Language (SSML)}
\usage{
ms_create_ssml(
  script,
  voice = NULL,
  gender = c("Female", "Male"),
  language = "en-US",
  escape = FALSE
)
}
\arguments{
\item{script}{A character vector of lines to be spoken}

\item{voice}{Full voice name,}

\item{gender}{Sex of the Speaker}

\item{language}{Language to be spoken}

\item{escape}{Should non-standard characters be substituted?  Should not
be used if \code{script} has SSML tags}
}
\value{
A character string of the text and SSML markup
}
\description{
Create Speech Synthesis Markup Language (SSML)
}
\examples{
ms_create_ssml("hey I really like things & dogs", escape = TRUE)
ms_create_ssml("hey I really like things")
ms_create_ssml('hey I <emphasis level="strong">really like</emphasis> things')
ms_create_ssml('hey I <emphasis level="strong">really like</emphasis> things',
escape = TRUE)

}
