% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0-SetS3.R, R/GroupGenericMath.R,
%   R/GroupGenericSummary.R, R/Ops-arithmetic.R, R/Ops-logic.R
\name{SetS3}
\alias{SetS3}
\alias{setnew}
\alias{as.set}
\alias{as.orderedset}
\alias{is.set}
\alias{is.orderedset}
\title{Set and ordered Set}
\usage{
setnew(..., .ordered = FALSE)

as.set(x)

as.orderedset(x)

is.set(x)

is.orderedset(x)
}
\arguments{
\item{...}{initial elements put into the \code{Set}.}

\item{.ordered}{\code{logical} if \code{TRUE} all elements in the \link{Set} will be
ordered.}

\item{x}{\code{R} object of \code{ANY} type for \code{\link[=as.set]{as.set()}} and \code{\link[=is.set]{is.set()}}
or of class \code{Set} for the \code{S3} methods.}
}
\description{
The \link{Set} is considered and implemented as a specialized
\link{Container}, that is, \code{Set} elements are always unique. It provides
typical set operations such as \code{union} and \code{intersect}.
}
\details{
Methods that alter \link{Set} objects usually come in two versions
providing either copy or reference semantics where the latter start with
\code{'ref_'} to note the reference semantic, for example,
\code{\link[=add]{add()}} and \code{\link[=ref_add]{ref_add()}}.

\itemize{
\item \code{setnew(...)} initializes and returns a \code{\link[=Set]{Set()}} object.
}

\itemize{
\item \code{as.set(x)} coerces \code{x} to a set.
}

\itemize{
\item \code{as.orderedset(x)} coerces \code{x} to an ordered set.
}

\itemize{
\item \code{is.set(x)} returns \code{TRUE} if \code{x} is of class \code{Set} and \code{FALSE}
otherwise.
}

\itemize{
\item \code{is.orderedset(x)} returns \code{TRUE} if \code{x} is of class \code{OrderedSet}
and \code{FALSE} otherwise.
}

\itemize{
\item \code{x} \code{&} \code{y} performs the set intersection of x and y
}

\itemize{
\item \code{x} \code{|} \code{y} performs the set union of x and y
}
}
\examples{
s = setnew(1, b = NA, 1:3, c = container("a", 1))
is.set(s)
print(s)
length(s)
names(s)
as.list(s)
unpack(s)   # flatten recursively similar to unlist

so = setnew(2, 1, .ordered = TRUE)
print(so)
add(so, 0)
# Math
s = setnew(5:3, 1, 2)
s
abs(s)
cumsum(s)
round(s)
exp(s)

# Summary
range(s)
min(s)
max(s)

s1 = setnew(1, 1:2)
s2 = setnew(2, 1:2)
s1 + s2     # same as s1 | s2 or c(c1, s2)
s2 + s1     # same

s1 - s2
s2 - s1

s1 = setnew(1, b = 2)
s2 = setnew(1, b = 4)
s1 & s2     # {1}

s1 | s2     # {1, b = 2, b = 4}

}
\seealso{
See \code{\link[=container]{container()}} for all inherited methods. For the full class
documentation see \link{Set} and it's superclass \link{Container}.
}
