% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest_subgroup_continuous.R
\name{forest_cont_subgroup}
\alias{forest_cont_subgroup}
\title{Forest Plot for Subgroup Meta-Analysis}
\usage{
forest_cont_subgroup(
  dat,
  m_t_col = "mean_t",
  sd_t_col = "sd_t",
  n_t_col = "n_t",
  m_c_col = "mean_c",
  sd_c_col = "sd_c",
  n_c_col = "n_c",
  subgroup_col = "subgroup",
  study_col = "Study",
  measure = "SMD",
  method = "REML",
  xlab = NULL,
  xlim = NULL,
  model = "RE",
  title = "Subgroup Forest Plot",
  diamond.col = "red",
  overall.col = "darkgreen",
  study.col = "blue",
  CI.col = "blue",
  Pred.Inter.col = "black",
  square.size = 5,
  Pred.Int.size = 1.5,
  text_size = 3.5,
  pred = TRUE,
  xpos = list(Study = NULL, MeanT = NULL, MeanC = NULL, Effect = NULL, Weight = NULL,
    PredInt = NULL, Hetero = NULL)
)
}
\arguments{
\item{dat}{A data frame containing the study-level data. Use \code{dat1} included in the package for examples.}

\item{m_t_col}{Name of the column for treatment group means.}

\item{sd_t_col}{Name of the column for treatment group standard deviations.}

\item{n_t_col}{Name of the column for treatment group sample sizes.}

\item{m_c_col}{Name of the column for control group means.}

\item{sd_c_col}{Name of the column for control group standard deviations.}

\item{n_c_col}{Name of the column for control group sample sizes.}

\item{subgroup_col}{Name of the column indicating subgroup membership.}

\item{study_col}{Name of the column with study labels.}

\item{measure}{Effect size measure: "SMD" (standardized mean difference) or "MD" (mean difference).}

\item{method}{Method for meta-analysis: "REML" (default) or "FE".}

\item{xlab}{Label for the x-axis.}

\item{xlim}{Limits for the x-axis as a numeric vector of length 2.}

\item{model}{Random-effects ("RE") or fixed-effects ("FE") model for pooled estimates.}

\item{title}{Plot title.}

\item{diamond.col}{Color for subgroup pooled effect diamonds.}

\item{overall.col}{Color for the overall pooled effect diamond.}

\item{study.col}{Color for study-level points.}

\item{CI.col}{Color for confidence intervals of individual studies.}

\item{Pred.Inter.col}{Color for the overall prediction interval.}

\item{square.size}{Maximum size of study-level effect squares.}

\item{Pred.Int.size}{Line thickness for prediction interval.}

\item{text_size}{Base text size for annotations.}

\item{pred}{Logical; if TRUE, display overall prediction interval.}

\item{xpos}{numeric vector of x-axis positions for annotations}
}
\value{
A ggplot object representing the subgroup forest plot.
}
\description{
Creates a detailed forest plot for subgroup meta-analysis, including study-level effect sizes,
subgroup pooled effects, heterogeneity statistics, overall pooled effect, and prediction intervals.
}
\examples{
# Using the built-in dataset dat1
forest_cont_subgroup(dat1)
}
