% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/damp.R
\name{damp}
\alias{damp}
\title{Damping and Natural Frequencies for Continuous Systems}
\usage{
damp(sys, doPrint = TRUE)
}
\arguments{
\item{sys}{A Continuous-time system of state-space, transfer-function or zero-pole-gain model.}

\item{doPrint}{If TRUE prints out the results. Default is TRUE.}
}
\value{
Returns the natrural frequencies and damping
factors in a list:

 omegan = Natural Frequencies (rad/s)
 zeta   = Damping Factors
}
\description{
\code{damp} computes the natural frequency and damping for
continuous systems.
}
\details{
A table of the eigenvalues of
the matrix a, the associated damping factors, the associated natural
frequency (rad/s and Hz.) is displayed by calling the function.

When the continuous system is a state-space model, the eigenvalues of the state matrix
are obtained and sorted.
If the system is a transfer-function, the poles of the systems are obtained and sorted.
For zero-pole systems, the poles are just extracted and sorted.
The sorted eigenvalues are printed to output and used to obtain the natural frequencies
and damping factors.
}
\examples{
sys1 <- tf(1, c(1,2,5))
damp(sys1)

}
\seealso{
\code{\link{esort}}
}
