% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robustness_tests.R
\name{test_reweighting_robustness}
\alias{test_reweighting_robustness}
\title{Reweighting-based robustness test}
\usage{
test_reweighting_robustness(
  path_cpi,
  path_weights,
  X_matrix,
  max_comp = 3,
  verbose = TRUE
)
}
\arguments{
\item{path_cpi}{Path to CPI data file}

\item{path_weights}{Path to weights data file}

\item{X_matrix}{Matrix of variables}

\item{max_comp}{Maximum number of components (default: 3)}

\item{verbose}{Logical; print progress and diagnostic information. Default \code{TRUE}.}
}
\value{
List with components:
\describe{
\item{\code{lambda_distribution}}{Matrix of lambda estimates across schemes.}
\item{\code{original_lambda}}{Baseline lambda from original weights.}
\item{\code{robust_factors}}{Logical vector indicating robust convergence.}
\item{\code{sensitivity_metrics}}{Summary statistics of sensitivity.}
}
}
\description{
Tests sensitivity of convergence results to alternative sectoral weighting
schemes by re-running Bayesian disaggregation and full pipeline with
perturbed weights.
}
