% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/b_sim.R
\name{b_sim}
\alias{b_sim}
\title{Simulate coefficients from a GLM by making draws from the multivariate
normal distribution}
\usage{
b_sim(obj, mu, Sigma, nsim = 1000)
}
\arguments{
\item{obj}{a fitted model object.}

\item{mu}{an optional vector giving the means of the variables. If \code{obj}
is supplied then \code{mu} is ignored.}

\item{Sigma}{an optional positive-definite symmetric matrix specifying the
covariance matrix of the variables. If \code{obj} is supplied then
\code{Sigma} is ignored. If your model includes an intercept, this should be
given the name \code{intercept_}.}

\item{nsim}{number of simulations to draw.}
}
\value{
A data frame of simulated coefficients from \code{obj}.
}
\description{
Simulate coefficients from a GLM by making draws from the multivariate
normal distribution
}
\examples{
library(car)

# Estimate model
m1 <- lm(prestige ~ education + type, data = Prestige)

# Create fitted values
prestige_sims <- b_sim(m1)

# Manually supply coefficient means and covariance matrix
coefs <- coef(m1)
vcov_matrix <- vcov(m1)

prestige_sims_manual <- b_sim(mu = coefs, Sigma = vcov_matrix)

}
