% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_systematic.R
\name{linear_systematic}
\alias{linear_systematic}
\title{Find the systematic component in the linear form for fitted values in across
each simulation (note: largely for internal use by \code{\link{qi_builder}})}
\source{
King, Gary, Michael Tomz, and Jason Wittenberg. 2000. "Making the
Most of Statistical Analyses: Improving Interpretation and Presentation."
American Journal of Political Science 44(2): 341-55.
}
\usage{
linear_systematic(b_sims, newdata, inc_intercept = TRUE)
}
\arguments{
\item{b_sims}{a data frame created by \code{\link{b_sim}} of simulated
coefficients.}

\item{newdata}{a data frame of fitted values with column names corresponding
to variable names in \code{b_sims}. Variables in \code{b_sim} not present
in \code{newdata} will be treated as fitted at 0. Interactions will
automatically be found if they were entered into to the model using the
\code{*} operator.}

\item{inc_intercept}{logical whether to include the intercept in the
lineary systematic component.}
}
\value{
A data frame fitted values supplied in \code{newdata} and associated
linear systematic component estimates for all simulationed coefficient
estimates. The linear systematic components are included in a column
named \code{ls_}.
}
\description{
Find the systematic component in the linear form for fitted values in across
each simulation (note: largely for internal use by \code{\link{qi_builder}})
}
\examples{
library(car)

# Estimate model
m1 <- lm(prestige ~ education + type, data = Prestige)

# Create fitted values
fitted_df <- expand.grid(education = 6:16, typewc = 1)

# Simulate coefficients
m1_sims <- b_sim(m1, nsim = 1000)

# Find linear systematic component for fitted values
ls <- linear_systematic(b_sims = m1_sims, newdata = fitted_df)

}
